/* 
 * File:   DataManager.hpp
 * Author: Yuri Meiburg
 *
 * Created on May 1, 2011, 12:21 PM
 */

#ifndef DATAMANAGER_HPP
#define	DATAMANAGER_HPP
#include <iostream>
#include <fstream>
#include <cstdlib>
#include "framebuffer.hpp"
#include "texture3D.hpp"
#include "glslProgram.h"
#include "ImageDecoder.hpp"

using namespace std;

typedef enum SHADER_TYPE_ {
    INVALID=-1,
    NORMAL,
    LOCAL_ALPHA,
    GLOBAL_ALPHA
} SHADER_TYPE;


typedef struct DataArr_ {
    float *data;
    int nEl;
} DataArr;

class DataManager {
private:
    int *dim;
    Texture3D *dataLoc;
    Framebuffer *fbo;
    GLSLProgram *sh_alpha;
    SHADER_TYPE SHADER;
    float border_size;

public:
    DataManager();
    ~DataManager();
    Texture2D* getAlphaMapOfLayer(int l);
    Texture2D* getDistanceTransform(int l);
    void initFBO();
    void setAlphaShader(SHADER_TYPE st);
    void setBorderSize(float b);
    float getBorderSize(){    return border_size; }
    void setData(image_t *im) {   data = im;    }
    void setWidth (int x){ dim[0] =  x; };
    void setHeight(int y){ dim[1] =  y; };
    int getWidth() {     return dim[0];    };
    int getHeight() {    return dim[1];    };
    void setClearColor();
private:
    image_t *data;
    layer_t *readLayer(int l);
};

#endif	/* DATAMANAGER_HPP */

